<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Menu extends Model 
{

    protected $table = 'menus';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('ceremonie_id', 'slug', 'nom', 'groupe', 'description', 'statut');
    protected $visible = array('ceremonie_id', 'slug', 'nom', 'groupe', 'description', 'statut');

    public function ceremonie()
    {
        return $this->belongsTo('App\Models\Ceremonie', 'ceremonie_id');
    }

}